/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.config;

import cofh.lib.config.IBaseConfig;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.item.SatchelItem;
import cofh.thermal.lib.common.ThermalFlags;
import cofh.thermal.lib.util.ThermalEnergyHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.ForgeConfigSpec;

public class ThermalCoreConfig
implements IBaseConfig {
    public static int deviceAugments = 3;
    public static int dynamoAugments = 4;
    public static int machineAugments = 4;
    public static int storageAugments = 3;
    public static int toolAugments = 4;
    public static boolean keepEnergy;
    public static boolean keepItems;
    public static boolean keepFluids;
    public static boolean keepAugments;
    public static boolean keepRSControl;
    public static boolean keepSideConfig;
    public static boolean keepTransferControl;
    public static boolean defaultReconfigSides;
    public static boolean defaultRSControl;
    public static boolean defaultXPStorage;
    public static boolean permanentLava;
    public static boolean permanentWater;
    public static boolean enableVillagerTrades;
    public static boolean enableWandererTrades;
    public static boolean mobBlitzLightning;
    private ForgeConfigSpec.BooleanValue boolStandaloneRedstoneFlux;
    private ForgeConfigSpec.BooleanValue boolKeepEnergy;
    private ForgeConfigSpec.BooleanValue boolKeepItems;
    private ForgeConfigSpec.BooleanValue boolKeepFluids;
    private ForgeConfigSpec.BooleanValue boolKeepAugments;
    private ForgeConfigSpec.BooleanValue boolKeepRSControl;
    private ForgeConfigSpec.BooleanValue boolKeepSideConfig;
    private ForgeConfigSpec.BooleanValue boolKeepTransferControl;
    private ForgeConfigSpec.BooleanValue boolReconfigSides;
    private ForgeConfigSpec.BooleanValue boolRSControl;
    private ForgeConfigSpec.BooleanValue boolXPStorage;
    private ForgeConfigSpec.BooleanValue boolPermanentLava;
    private ForgeConfigSpec.BooleanValue boolPermanentWater;
    private ForgeConfigSpec.BooleanValue boolVillagerTrades;
    private ForgeConfigSpec.BooleanValue boolWandererTrades;
    private ForgeConfigSpec.BooleanValue boolVanillaBlocks;
    private ForgeConfigSpec.BooleanValue boolRockwool;
    private ForgeConfigSpec.BooleanValue boolWrench;
    private ForgeConfigSpec.BooleanValue boolRedprint;
    private ForgeConfigSpec.BooleanValue boolRFPotato;
    private ForgeConfigSpec.BooleanValue boolXPCrystal;
    private ForgeConfigSpec.BooleanValue boolLock;
    private ForgeConfigSpec.BooleanValue boolSatchel;
    private ForgeConfigSpec.BooleanValue boolDetonator;
    private ForgeConfigSpec.BooleanValue boolMobBasalz;
    private ForgeConfigSpec.BooleanValue boolMobBlitz;
    private ForgeConfigSpec.BooleanValue boolMobBlizz;
    private ForgeConfigSpec.BooleanValue boolMobBlitzLightning;
    private ForgeConfigSpec.ConfigValue<List<String>> listSatchelBans;

    public void apply(ForgeConfigSpec.Builder builder) {
        builder.push("Global Options");
        this.boolStandaloneRedstoneFlux = builder.comment("If TRUE, Redstone Flux will act as its own energy system and will NOT be interoperable with 'Forge Energy' - only enable this if you absolutely know what you are doing and want the Thermal Series to use a unique energy system.").define("Standalone Redstone Flux", false);
        this.boolKeepEnergy = builder.comment("If TRUE, most Thermal Blocks will retain Energy when dropped.\nThis setting does not control ALL blocks.").define("Blocks Retain Energy", true);
        this.boolKeepItems = builder.comment("If TRUE, most Thermal Blocks will retain Inventory Contents when dropped.\nThis setting does not control ALL blocks.").define("Blocks Retain Inventory", false);
        this.boolKeepFluids = builder.comment("If TRUE, most Thermal Blocks will retain Tank Contents when dropped.\nThis setting does not control ALL blocks.").define("Blocks Retain Tank Contents", false);
        this.boolKeepAugments = builder.comment("If TRUE, Thermal Blocks will retain Augments when dropped.").define("Blocks Retain Augments", true);
        this.boolKeepRSControl = builder.comment("If TRUE, Thermal Blocks will retain Redstone Control configuration when dropped.").define("Blocks Retain Redstone Control", true);
        this.boolKeepSideConfig = builder.comment("If TRUE, Thermal Blocks will retain Side configuration when dropped.").define("Blocks Retain Side Configuration", true);
        this.boolKeepTransferControl = builder.comment("If TRUE, Thermal Blocks will retain Transfer Control configuration when dropped.").define("Blocks Retain Transfer Control", true);
        builder.pop();
        builder.push("Features");
        this.boolVanillaBlocks = builder.comment("If TRUE, various 'Vanilla+' Blocks and Recipes are enabled.").define("Vanilla+", true);
        this.boolRockwool = builder.comment("If TRUE, Rockwool Blocks and Recipes are enabled.").define("Rockwool", true);
        builder.push("Tools");
        this.boolWrench = builder.comment("If TRUE, the Crescent Hammer is enabled.").define("Wrench", true);
        this.boolRedprint = builder.comment("If TRUE, the Redprint is enabled.").define("Redprint", true);
        this.boolRFPotato = builder.comment("If TRUE, the Capacitato is enabled.").define("RF Potato", true);
        this.boolXPCrystal = builder.comment("If TRUE, the Insightful Crystal is enabled.").define("XP Crystal", true);
        this.boolLock = builder.comment("If TRUE, the Signalum Security Lock is enabled.").define("Lock", true);
        this.boolDetonator = builder.comment("If TRUE, the Remote Detonator is enabled.").define("Detonator", true);
        builder.push("Satchel");
        this.boolSatchel = builder.comment("If TRUE, the Satchel is enabled.").define("Satchel", true);
        String[] shulkerBoxes = new String[]{};
        try {
            shulkerBoxes = new String[]{"thermal:satchel", Items.f_42265_.getRegistryName().toString(), Items.f_42266_.getRegistryName().toString(), Items.f_42267_.getRegistryName().toString(), Items.f_42268_.getRegistryName().toString(), Items.f_42269_.getRegistryName().toString(), Items.f_42270_.getRegistryName().toString(), Items.f_42271_.getRegistryName().toString(), Items.f_42272_.getRegistryName().toString(), Items.f_42273_.getRegistryName().toString(), Items.f_42274_.getRegistryName().toString(), Items.f_42275_.getRegistryName().toString(), Items.f_42224_.getRegistryName().toString(), Items.f_42225_.getRegistryName().toString(), Items.f_42226_.getRegistryName().toString(), Items.f_42227_.getRegistryName().toString(), Items.f_42228_.getRegistryName().toString(), Items.f_42229_.getRegistryName().toString()};
        }
        catch (Throwable t) {
            ThermalCore.LOG.error("A Shulker Box was NULL. This is really bad.", t);
        }
        this.listSatchelBans = builder.comment("A list of Items by Resource Location which are NOT allowed in Satchels.").define("Denylist", new ArrayList<String>(Arrays.asList(shulkerBoxes)));
        builder.pop(2);
        builder.push("Mobs");
        this.boolMobBasalz = builder.comment("If TRUE, the Basalz Mob is enabled.").define("Basalz", true);
        this.boolMobBlitz = builder.comment("If TRUE, the Blitz Mob is enabled.").define("Blitz", true);
        this.boolMobBlizz = builder.comment("If TRUE, the Blizz Mob is enabled.").define("Blizz", true);
        this.boolMobBlitzLightning = builder.comment("If TRUE, the Blitz can occasionally call down lightning bolts.").define("Blitz Lightning", mobBlitzLightning);
        builder.pop(2);
        builder.push("Augments");
        this.boolReconfigSides = builder.comment("If TRUE, Side Reconfiguration is enabled by default on most augmentable blocks which support it.\nIf FALSE, an augment is required.\nThis setting does not control ALL blocks.").define("Default Side Reconfiguration", defaultReconfigSides);
        this.boolRSControl = builder.comment("If TRUE, Redstone Control is enabled by default on most augmentable blocks which support it.\nIf FALSE, an augment is required.\nThis setting does not control ALL blocks.").define("Default Redstone Control", defaultRSControl);
        this.boolXPStorage = builder.comment("If TRUE, XP Storage is enabled by default on most augmentable blocks which support it.\nIf FALSE, an augment is required.\nThis setting does not control ALL blocks.").define("Default XP Storage", defaultXPStorage);
        builder.pop();
        builder.push("Villagers");
        this.boolVillagerTrades = builder.comment("If TRUE, trades will be added to various Villagers.").define("Enable Villager Trades", true);
        this.boolWandererTrades = builder.comment("If TRUE, trades will be added to the Wandering Trader.").define("Enable Wandering Trader Trades", true);
        builder.pop();
    }

    public void refresh() {
        ThermalEnergyHelper.standaloneRedstoneFlux = (Boolean)this.boolStandaloneRedstoneFlux.get();
        keepEnergy = (Boolean)this.boolKeepEnergy.get();
        keepItems = (Boolean)this.boolKeepItems.get();
        keepFluids = (Boolean)this.boolKeepFluids.get();
        keepAugments = (Boolean)this.boolKeepAugments.get();
        keepRSControl = (Boolean)this.boolKeepRSControl.get();
        keepSideConfig = (Boolean)this.boolKeepSideConfig.get();
        keepTransferControl = (Boolean)this.boolKeepTransferControl.get();
        defaultReconfigSides = (Boolean)this.boolReconfigSides.get();
        defaultRSControl = (Boolean)this.boolRSControl.get();
        defaultXPStorage = (Boolean)this.boolXPStorage.get();
        enableVillagerTrades = (Boolean)this.boolVillagerTrades.get();
        enableWandererTrades = (Boolean)this.boolWandererTrades.get();
        mobBlitzLightning = (Boolean)this.boolMobBlitzLightning.get();
        ThermalFlags.setFlag(ThermalFlags.FLAG_VANILLA_BLOCKS, (Boolean)this.boolVanillaBlocks.get());
        ThermalFlags.setFlag(ThermalFlags.FLAG_ROCKWOOL, (Boolean)this.boolRockwool.get());
        ThermalFlags.setFlag("wrench", (Boolean)this.boolWrench.get());
        ThermalFlags.setFlag("redprint", (Boolean)this.boolRedprint.get());
        ThermalFlags.setFlag("rf_potato", (Boolean)this.boolRFPotato.get());
        ThermalFlags.setFlag("xp_crystal", (Boolean)this.boolXPCrystal.get());
        ThermalFlags.setFlag("lock", (Boolean)this.boolLock.get());
        ThermalFlags.setFlag("satchel", (Boolean)this.boolSatchel.get());
        ThermalFlags.setFlag("detonator", (Boolean)this.boolDetonator.get());
        ThermalFlags.setFlag(ThermalFlags.FLAG_MOB_BASALZ, (Boolean)this.boolMobBasalz.get());
        ThermalFlags.setFlag(ThermalFlags.FLAG_MOB_BLITZ, (Boolean)this.boolMobBlitz.get());
        ThermalFlags.setFlag(ThermalFlags.FLAG_MOB_BLIZZ, (Boolean)this.boolMobBlizz.get());
        ThermalFlags.setFlag(ThermalFlags.FLAG_SIDE_CONFIG_AUGMENT, (Boolean)this.boolReconfigSides.get() == false);
        ThermalFlags.setFlag(ThermalFlags.FLAG_RS_CONTROL_AUGMENT, (Boolean)this.boolRSControl.get() == false);
        ThermalFlags.setFlag(ThermalFlags.FLAG_XP_STORAGE_AUGMENT, (Boolean)this.boolXPStorage.get() == false);
        SatchelItem.setBannedItems((Collection)this.listSatchelBans.get());
    }

    static {
        defaultReconfigSides = true;
        defaultRSControl = true;
        defaultXPStorage = false;
        permanentLava = true;
        permanentWater = true;
        enableVillagerTrades = true;
        enableWandererTrades = true;
        mobBlitzLightning = true;
    }
}

